--Sierpinski carpet
-- A demo for Lua Turtle 

function sierpin(x, y, w, h, n)
	turtle.SetColor("yellow");
	fillRect(x,y,w,h);				--draw one big rectangle
	turtle.SetColor("blue");
	return sierpin_rek(x,y,w,h,n);	--'cut out' smaller parts
end

function sierpin_rek(x, y, w, h, n)	--recursive cut out function
	if(n < 1) then return; end
	if((w < 3) or (h < 3)) then return; end
	
	--cut one rectangle from the middle:
	fillRect(x+(math.floor(w/3)), y-(math.floor(h/3)), math.floor(w/3), math.floor(h/3));
	
	--and then recursively cut smaller rectangles from the borders:
	for i=0, 2 do
		for j=0, 2 do
			local lw = math.floor(w/3);
			local lh = math.floor(h/3);
			if((i ~= 1) or (j ~= 1)) then	--don't process middle square
				sierpin(x+(i*lw), y-(j*lh), lw, lh, n-1);
			end
		end
	end
end

--Helper function, draws a filled rectangle
-- x,y - Topleft corner of rectangle
-- w,h - width and height of rectangle
function fillRect(x, y, w, h)
	turtle.PenUp();
	turtle.Goto(x, y);
	turtle.SetAngle(0);
	for i=1, h do
		turtle.PenDown();
		turtle.Go(w);
		turtle.PenUp();
		turtle.Go(-w);
		turtle.TurnRight(90);
		turtle.Go(1);
		turtle.TurnLeft(90);
	end
end


--Program entry:
print("Sierpinski Carpet");
sierpin(-300, 250, 629, 529, 100);